/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.device.HiveExtractorMapping;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HiveExtractorMappingSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<HiveExtractorMapping> {
    public HiveExtractorMapping fromJson(ResourceLocation recipeId, JsonObject json) {
        Block hive = Blocks.f_50016_;
        ItemStack item = ItemStack.f_41583_;
        FluidStack fluid = FluidStack.EMPTY;
        if (json.has("hive")) {
            hive = RecipeJsonUtils.parseBlock((JsonElement)json.get("hive"));
        }
        if (json.has("item")) {
            item = RecipeJsonUtils.parseItemStack((JsonElement)json.get("item"));
        }
        if (json.has("fluid")) {
            fluid = RecipeJsonUtils.parseFluidStack((JsonElement)json.get("fluid"));
        }
        return new HiveExtractorMapping(recipeId, hive, item, fluid);
    }

    @Nullable
    public HiveExtractorMapping fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Block hive = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        ItemStack item = buffer.m_130267_();
        FluidStack fluid = buffer.readFluidStack();
        return new HiveExtractorMapping(recipeId, hive, item, fluid);
    }

    public void toNetwork(FriendlyByteBuf buffer, HiveExtractorMapping recipe) {
        buffer.m_130085_(recipe.hive.getRegistryName());
        buffer.m_130055_(recipe.item);
        buffer.writeFluidStack(recipe.fluid);
    }
}

